% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{result_list}
\alias{result_list}
\title{List saved results from the framework database}
\usage{
result_list(type = NULL, public = NULL)
}
\arguments{
\item{type}{Optional filter by type: "table", "figure", "model", "report", "notebook"}

\item{public}{Optional filter: TRUE for public results only, FALSE for private only}
}
\value{
A data frame with columns: name, type, public, comment, hash, created_at, updated_at.
Returns an empty data frame if no results found or database unavailable.
}
\description{
Retrieves a list of all saved results (tables, figures, models, reports,
notebooks) that have been tracked via the save_* functions.
}
\examples{
\donttest{
if (FALSE) {
# List all results
result_list()

# List only tables
result_list(type = "table")

# List only public figures
result_list(type = "figure", public = TRUE)
}
}

}
