% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_helpers.R
\name{db_with}
\alias{db_with}
\title{Execute code with a managed database connection}
\usage{
db_with(connection_name, code)
}
\arguments{
\item{connection_name}{Character. Name of the connection in config.yml}

\item{code}{Expression to evaluate with the connection (use \code{conn} to access the connection)}
}
\value{
The result of evaluating \code{code}
}
\description{
Provides automatic connection lifecycle management. The connection is
automatically closed when the code block finishes, even if an error occurs.
This prevents connection leaks and ensures proper resource cleanup.
}
\examples{
\donttest{
if (FALSE) {
# Safe - connection auto-closes
users <- db_with("my_db", {
  DBI::dbGetQuery(conn, "SELECT * FROM users WHERE active = TRUE")
})

# Multiple operations with same connection
result <- db_with("my_db", {
  DBI::dbExecute(conn, "INSERT INTO users (name) VALUES ('Alice')")
  DBI::dbGetQuery(conn, "SELECT * FROM users")
})

# Connection closes even on error
tryCatch(
  db_with("my_db", {
    stop("Something went wrong")  # Connection still closes
  }),
  error = function(e) message(e$message)
)
}
}

}
