% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-get-optimal-builtup.R
\name{DoU_get_optimal_builtup}
\alias{DoU_get_optimal_builtup}
\title{Get the optimal built-up area threshold}
\usage{
DoU_get_optimal_builtup(
  data,
  density_threshold = 1500,
  size_threshold = 5000,
  directions = 4
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}. Ideally, it contains data on a global scale.}

\item{density_threshold}{numeric. Minimum population density per permanent land}

\item{size_threshold}{numeric. Minimum population size}

\item{directions}{integer. Which cells are considered adjacent: \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}
}
\value{
optimal built-up area threshold
}
\description{
In Data Package 2023, the Degree of Urbanisation includes a "Reduce Fragmentation Option" to account for the presence of office parks, shopping malls, factories and transport infrastructure. When the setting is enabled, urban centres are created using both cells with a population density of at least 1500 inhabitants per km² \emph{and} cells that have an "optimal" built-up area on permanent land. This function can be used to determine this "optimal" threshold value.

The optimal threshold is dynamically identified as the global average built-up area proportion in clusters with a density of at least 1500 inhabitants per permanent land with a minimum population of 5000 people. We empirically discovered that the Degree of Urbanisation uses the rounded up (ceiled) optimal threshold to two decimal places.

For more information: see \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023, footnote 30}. The arguments of the function allow to adapt the standard specifications in order to determine an alternative "optimal" threshold.
}
\examples{
data_belgium <- DoU_load_grid_data_belgium()

# determine the optimal built-up threshold with standard specifications
DoU_get_optimal_builtup(data_belgium)

# determine the optimal built-up threshold with custom specification
DoU_get_optimal_builtup(data_belgium,
  density_threshold = 1000,
  size_threshold = 3500,
  directions = 8
)
}
