% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORS.R
\name{CORS}
\alias{CORS}
\title{Plugin for setting up CORS in a fiery server}
\description{
Cross-Origin Resource Sharing (CORS) is a mechanism for servers to indicate
from where it may be accessed and allows browsers to block requests that are
not permitted. For security reasons, browsers limits requests initiated from
JavaScript to only those for the same site. To allow requests from other
sites the server needs to send the right CORS headers with the response. Read
more about CORS at \href{https://developer.mozilla.org/docs/Web/HTTP/Guides/CORS}{MDN}
}
\details{
CORS is opt-in. The security measure is already in place in browsers to limit
cross-origin requests, and CORS is a way to break out of this in a controlled
manner where you can indicate exactly who can make a request and what
requests can be made. In general it works like this:
\enumerate{
\item A request is being initiated from a website, either through JavaScript or
another venue, to a site different than the one it originates from.
\item The browser identifies that the request is cross-origin and sends an
\code{OPTIONS} request to the server with information about the request it
intends to send (this is called a pre-flight request).
\item The server responds with a 204 response giving the allowed types of
requests that can be made for the resource.
\item If the original request conforms to the response the browser will then
send the actual request.
\item The server responds to the actual request.
\item The client gets the response, but the browser will limit what information
in the response it can access based on the information provided by the
server in the pre-flight response.
}

As can be seen, a CORS request is slightly more complex than the standard
request-response you normally think about. However, the pre-flight request
can be cached by the browser and so, will not happen every time a ressource
is accessed. While a site may employ a CORS policy the same way across all
its endpoints it does not need to. It is fine to only turn on CORS for a
subset of paths. In general it is a good rule of thumb to set up
\link[=ResourceIsolation]{resource isolation} for the paths that do not have CORS
enabled.
}
\section{Initialization}{

A new 'CORS'-object is initialized using the \code{new()} method on the
generator and pass in any settings deviating from the defaults

\strong{Usage}
\tabular{l}{
\code{cors <- CORS$new(...)}
}
}

\section{Fiery plugin}{

A CORS object is a fiery plugin and can be used by passing it
to the \code{attach()} method of the fiery server object. Once attached all
requests will be passed through the plugin and the policy applied to it
}

\examples{
# Setup CORS for a sub path allowing access from www.trustworthy.com
# Tell the browser to cache the preflight for a day
cors <- CORS$new(
  path = "/shared_assets/*",
  origin = "https://www.trustworthy.com",
  methods = c("get", "head", "post"),
  max_age = 86400
)

\dontshow{if (requireNamespace("fiery", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use it in a fiery server
app <- fiery::Fire$new()

app$attach(cors)
\dontshow{\}) # examplesIf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name of the plugin}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CORS-new}{\code{CORS$new()}}
\item \href{#method-CORS-add_path}{\code{CORS$add_path()}}
\item \href{#method-CORS-on_attach}{\code{CORS$on_attach()}}
\item \href{#method-CORS-clone}{\code{CORS$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CORS-new"></a>}}
\if{latex}{\out{\hypertarget{method-CORS-new}{}}}
\subsection{Method \code{new()}}{
Initialize a CORS object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CORS$new(
  path = "/*",
  origin = "*",
  methods = c("get", "head", "put", "patch", "post", "delete"),
  allowed_headers = NULL,
  exposed_headers = NULL,
  allow_credentials = FALSE,
  max_age = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path that the policy should apply to. routr path syntax
applies, meaning that wilcards and path parameters are allowed.}

\item{\code{origin}}{The origin allowed for the path. Can be one of:
\itemize{
\item A boolean. If \code{TRUE} then all origins are permitted and the preflight
response will have the \code{Access-Control-Allow-Origin} header reflect
the origin of the request. If \code{FALSE} then all origins are denied
\item The string \code{"*"} which will allow all origins and set
\code{Access-Control-Allow-Origin} to \code{*}. This is different than setting it
to \code{TRUE} because \code{*} instructs browsers that any origin is allowed and
it may use this information when searching the cache
\item A character vector giving allowed origins. If the request origin
matches any of these then the \code{Access-Control-Allow-Origin} header in
the response will reflect the origin of the request
\item A function taking the request and returning \code{TRUE} if the origin is
permitted and \code{FALSE} if it is not. If permitted the
\code{Access-Control-Allow-Origin} header will reflect the request origin
}}

\item{\code{methods}}{The HTTP methods allowed for the \code{path}}

\item{\code{allowed_headers}}{A character vector of request headers allowed when
making the request. If the request contains headers not permitted, then
the response will be blocked by the browser. \code{NULL} will allow any header
by reflecting the \code{Access-Control-Request-Headers} header value from the
request into the \code{Access-Control-Allow-Headers} header in the response.}

\item{\code{exposed_headers}}{A character vector of response headers that should
be made available to the client upon a succesful request}

\item{\code{allow_credentials}}{A boolean indicating whether credentials are
allowed in the request. Credentials are cookies or HTTP authentication
headers, which are normally stripped from \code{fetch()} requests by the
browser. If this is \code{TRUE} then \code{origin} cannot be \code{*} according to the
spec}

\item{\code{max_age}}{The duration browsers are allowed to keep the preflight
response in the cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CORS-add_path"></a>}}
\if{latex}{\out{\hypertarget{method-CORS-add_path}{}}}
\subsection{Method \code{add_path()}}{
Add CORS settings to a path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CORS$add_path(
  path = "/*",
  origin = "*",
  methods = c("get", "head", "put", "patch", "post", "delete"),
  allowed_headers = NULL,
  exposed_headers = NULL,
  allow_credentials = FALSE,
  max_age = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path that the policy should apply to. routr path syntax
applies, meaning that wilcards and path parameters are allowed.}

\item{\code{origin}}{The origin allowed for the path. Can be one of:
\itemize{
\item A boolean. If \code{TRUE} then all origins are permitted and the preflight
response will have the \code{Access-Control-Allow-Origin} header reflect
the origin of the request. If \code{FALSE} then all origins are denied
\item The string \code{"*"} which will allow all origins and set
\code{Access-Control-Allow-Origin} to \code{*}. This is different than setting it
to \code{TRUE} because \code{*} instructs browsers that any origin is allowed and
it may use this information when searching the cache
\item A character vector giving allowed origins. If the request origin
matches any of these then the \code{Access-Control-Allow-Origin} header in
the response will reflect the origin of the request
\item A function taking the request and returning \code{TRUE} if the origin is
permitted and \code{FALSE} if it is not. If permitted the
\code{Access-Control-Allow-Origin} header will reflect the request origin
}}

\item{\code{methods}}{The HTTP methods allowed for the \code{path}}

\item{\code{allowed_headers}}{A character vector of request headers allowed when
making the request. If the request contains headers not permitted, then
the response will be blocked by the browser. \code{NULL} will allow any header
by reflecting the \code{Access-Control-Request-Headers} header value from the
request into the \code{Access-Control-Allow-Headers} header in the response.}

\item{\code{exposed_headers}}{A character vector of response headers that should
be made available to the client upon a succesful request}

\item{\code{allow_credentials}}{A boolean indicating whether credentials are
allowed in the request. Credentials are cookies or HTTP authentication
headers, which are normally stripped from \code{fetch()} requests by the
browser. If this is \code{TRUE} then \code{origin} cannot be \code{*} according to the
spec}

\item{\code{max_age}}{The duration browsers are allowed to keep the preflight
response in the cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CORS-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-CORS-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Method for use by \code{fiery} when attached as a plugin. Should
not be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CORS$on_attach(app, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The fiery server object}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CORS-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CORS-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CORS$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
