% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-cdf.R
\name{utils_cdf}
\alias{utils_cdf}
\title{Cumulative Distribution Functions for Probability Models}
\usage{
utils_cdf(q, distribution, params, ns_slice = 0, ns_structure = NULL)
}
\arguments{
\item{q}{Numeric vector of quantiles with no missing values.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{params}{Numeric vector of distribution parameters, in the order (location,
scale, shape). The length must be between 2 and 5, depending on the specified
\code{distribution} and \code{structure}.}

\item{ns_slice}{For NS-FFA only: Numeric scalar specifying the year at which to
evaluate  the quantiles of a nonstationary probability distribution. \code{ns_slice}
does not have to be an element of the \code{ns_years} argument.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
A numeric vector of quantiles with the same length as \code{q}.
}
\description{
Compute probabilities from quantiles for both stationary and nonstationary models.

\strong{For NS-FFA}: To compute the probabilities for a nonstationary model, specify a
time slice (\code{ns_slice}) and the nonstationary model structure (\code{ns_structure}).
}
\examples{
q <- seq(1, 10)
params <- c(1, 1, 1)
utils_cdf(q, "GEV", params)

}
