#' CAN-07BE001
#'
#' A dataframe of annual maximum series observations for 
#' station 07BE001, ATHABASCA RIVER AT ATHABASCA in Alberta, Canada. 
#'
#' @section Additional Information:
#' This is an unregulated station that is not in the RHBN. Additionally,
#' - The MKS/Pettitt tests find no evidence of change points at the 0.05 significance level.
#' - Trend detection finds no evidence of trends in the mean or variability.
#' 
#' This dataset is an excellent introductory example to stationary FFA.
#'
#' @format A dataframe with 108 rows and 2 columns spanning the period 1913-2020.
#'
#' @source Meteorological Service of Canada (MSC) GeoMet Platform
#'
#' @details Variables:
#' - `max`: Numeric; the observed annual maximum series, in m\eqn{^3}{^3}/s.
#' - `year`: Integer; the corresponding years.

"CAN_07BE001"
