% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model}
\alias{model}
\alias{model.tbl_ts}
\title{Estimate models}
\usage{
model(.data, ...)

\method{model}{tbl_ts}(.data, ..., .safely = TRUE)
}
\arguments{
\item{.data}{A data structure suitable for the models (such as a \code{tsibble})}

\item{...}{Definitions for the models to be used. All models must share the
same response variable.}

\item{.safely}{If a model encounters an error, rather than aborting the process a \link[=null_model]{NULL model} will be returned instead. This allows for an error to occur when computing many models, without losing the results of the successful models.}
}
\description{
Trains specified model definition(s) to a dataset. This function will
estimate the a set of model definitions (passed via \code{...}) to each series
within \code{.data} (as identified by the key structure). The result will be a
mable (a model table), which neatly stores the estimated models in a tabular
structure. Rows of the data identify different series within the data, and
each model column contains all models from that model definition. Each cell
in the mable identifies a single model.
}
\section{Parallel}{


It is possible to estimate models in parallel using the
\href{https://cran.r-project.org/package=future}{future} package. By specifying a
\code{\link[future:plan]{future::plan()}} before estimating the models, they will be computed
according to that plan.
}

\section{Progress}{


Progress on model estimation can be obtained by wrapping the code with
\code{progressr::with_progress()}. Further customisation on how progress is
reported can be controlled using the \code{progressr} package.
}

\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE) && requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fable)
library(tsibbledata)

# Training an ETS(M,Ad,A) model to Australian beer production
aus_production \%>\%
  model(ets = ETS(log(Beer) ~ error("M") + trend("Ad") + season("A")))

# Training a seasonal naive and ETS(A,A,A) model to the monthly 
# "Food retailing" turnover for selected Australian states.
library(dplyr)
progressr::with_progress(
aus_retail \%>\% 
  filter(
    Industry == "Food retailing",
    State \%in\% c("Victoria", "New South Wales", "Queensland")
  ) \%>\% 
  model(
    snaive = SNAIVE(Turnover),
    ets = ETS(log(Turnover) ~ error("A") + trend("A") + season("A")),
  )
)
\dontshow{\}) # examplesIf}
}
