% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate}
\alias{interpolate}
\title{Interpolation of missing data (NAs)}
\usage{
interpolate(
  data,
  maxgap = 150,
  method = "approx",
  sample_rate = NULL,
  report = FALSE
)
}
\arguments{
\item{data}{dataframe with columns time, x, y, trial (the standardised raw data form for eyeproc)}

\item{maxgap}{maximum time gap of consecutive trackloss to fill (in ms). Any longer gaps will be left unchanged (see zoo package)}

\item{method}{"approx" for linear interpolation or "spline" for cubic spline interpolation}

\item{sample_rate}{Optional sample rate of the eye-tracker (Hz) for use with data. If not supplied, the sample rate will be estimated from the time column and the number of samples.}

\item{report}{default is FALSE. If TRUE, then the return value is a list containing the returned data frame and the report.}
}
\value{
a dataframe of the same shape of the input data
}
\description{
Extends the zoo::na.approx and zoo::na.spline functions to include a report which provides
the proportion of missing data before and after the interpolation process. This is handy
for evaluating the effectiveness of the repair.
}
\details{
Analyses data separately for each unique combination of values in \code{pID} and \code{trial}.
}
\examples{
data <- combine_eyes(HCL)
interpolate(data, maxgap = 150)

}
