% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_different.R
\name{all_different}
\alias{all_different}
\alias{values_different}
\title{Difference Testing Functions}
\usage{
all_different(obj, tol)

values_different(values, candidates, tol = 0.1)
}
\arguments{
\item{obj}{Numeric vector, matrix, or data frame to test for differences. Non-numeric inputs will be coerced to numeric if possible.}

\item{tol}{Numeric scalar specifying the minimum allowable difference between values.}

\item{values}{Numeric vector of initial values.}

\item{candidates}{Numeric vector of candidate values to add if sufficiently different.}
}
\value{
\itemize{
\item \code{all_different}: Logical (\code{TRUE} if all differences exceed \code{tol}, \code{FALSE} otherwise).
\item \code{values_different}: Numeric vector with original \code{values} plus any \code{candidates} that meet the difference criterion.
}
}
\description{
These functions determine whether numeric values are sufficiently different from each other based on a specified tolerance.
\itemize{
\item \code{all_different}: Checks if all differences between entries in a numeric object exceed a given tolerance.
\item \code{values_different}: Adds candidate values to a set of initial values only if they are sufficiently different from all existing values.
}
}
\examples{
# Check if all values are sufficiently different
x <- runif(10)   # 10 random values between 0 and 1
all_different(x, tol = 0.01)
all_different(x, tol = 0.5)

# Add sufficiently different candidate values
starting_values <- c(0.1, 0.5, 0.9)
candidates <- c(0.15, 0.4, 0.8, 1.2)
values_different(starting_values, candidates, tol = 0.2)
}
