% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pkg.R
\name{check_pkg}
\alias{check_pkg}
\title{check_pkg(): Check if packages are installed and optionally install them}
\usage{
check_pkg(
  pkg = NULL,
  source = c("CRAN", "GitHub", "Bioconductor"),
  auto_install = TRUE,
  ...
)
}
\arguments{
\item{pkg}{Character vector of package names or GitHub repos (e.g., "r-lib/devtools").}

\item{source}{Package source: one of "CRAN", "GitHub", "Bioconductor". Case-insensitive.}

\item{auto_install}{Logical. If TRUE (default), install missing packages automatically.}

\item{...}{Additional arguments passed to \code{inst_pkg()}.}
}
\value{
A tibble with columns: \code{package}, \code{name}, \code{installed}, \code{source}.
}
\description{
A utility to check whether CRAN / GitHub / Bioconductor packages are installed,
with optional auto-installation via \code{inst_pkg()}.
}
\examples{
check_pkg("ggplot2", source = "CRAN")
check_pkg("r-lib/devtools", source = "GitHub", auto_install = FALSE)
}
