% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_from_vol.R
\name{bin.from.vol}
\alias{bin.from.vol}
\title{Creation of a binary volume according to the voxel values of a volume}
\usage{
bin.from.vol(
  vol,
  min = -Inf,
  max = Inf,
  in.selection = TRUE,
  alias = "",
  description = NULL
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{min}{Minimum value of the selected voxel. Default to \code{-Inf}.}

\item{max}{Maximum value of the selected voxel. Default to \code{+Inf}.}

\item{in.selection}{Boolean, defaults to \code{TRUE}. If \code{in.selection = FALSE},
the selected pixels are those whose value is not between \code{min} and \code{max}.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (min, vol$object.alias, max, sep = "<=")} or if
\code{in.selection = FALSE}, \code{paste ("!(", description, ")")}.}
}
\value{
Returns a "volume" class object of \code{"binary"} modality,
with the same grid as \code{vol}, in which the selected voxels
(i.e. set to TRUE) are those satisfying the following conditions :
\itemize{
\item If \code{in.selection = TRUE}, then \code{min <= vol$vol3D.data <= max}.
\item If \code{in.selection = FALSE}, then \code{vol$vol3D.data < min} or
\code{max < vol$vol3D.data}
}
}
\description{
The \code{bin.from.vol} function creates a "volume" class
object, of "binary" modality, in which the voxels fulfilling a condition on
their value are selected.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 3
patient <- toy.load.patient (modality = "ct", roi.name = "", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]

bin.bone <- bin.from.vol (CT, min = 300, max = 3000, alias = "bone")
display.plane (CT, top = bin.bone, interpolate = FALSE)
}
