% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_report_grouped_stats}
\alias{epitrax_report_grouped_stats}
\title{Create grouped disease statistics report from an EpiTrax object}
\usage{
epitrax_report_grouped_stats(epitrax, is.public = FALSE)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{is.public}{Logical indicating whether to generate a public report using
the public disease list. If FALSE (default), generates an internal report using
the internal disease list.}
}
\value{
Updated EpiTrax object with grouped statistics report added to either
the \code{internal_reports} or \code{public_reports} field, depending on the \code{is.public}
parameter.
}
\description{
\code{epitrax_report_grouped_stats} generates a comprehensive report with current
and historical statistics for diseases organized by group. The report includes
monthly counts/rates, historical averages and medians, year-to-date counts, and
trend analysis. It can be run for either internal or public reports.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_report_grouped_stats()

names(epitrax$internal_reports)
}
