% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.registerMap}
\alias{ec.registerMap}
\title{Register a geoJson map}
\usage{
ec.registerMap(wt = NULL, name = "loadedMapName", data = NULL)
}
\arguments{
\item{wt}{An \code{echarty} widget as returned by \link{ec.init}.\cr}

\item{name}{Name of map.\cr}

\item{data}{A string starting with \emph{http} or \emph{file}. URL strings ending with \emph{.svg} are assumed to be SVG map files.\cr
Could also be a valid geoJSON or SVG text string. SVG strings start with either \emph{<?xml} or \emph{<svg}.\cr}
}
\value{
An \emph{echarty} widget.
}
\description{
Read geoJSON file to be used in a map chart\cr
\strong{Deprecated} since v.1.7.0, use ec.init(registerMap=...) instead.
}
\details{
This command replaces the manual setting through \emph{p$x$registerMap}.\cr
It should always be piped after \link{ec.init}.\cr
There should be one map series with attribute 'map' matching the name parameter.\cr
}
\examples{
data.frame(name= c('Texas', 'California'), value= c(111, 222)) |> 
ec.init( color= c('lightgray'), visualMap= list(min=111),
  series.param= list(type= 'map', map= 'usa')
) |> 
ec.registerMap('usa', 'https://echarts.apache.org/examples/data/asset/geo/USA.json')

}
