% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{e_graph}
\alias{e_graph}
\alias{e_graph_gl}
\alias{e_graph_nodes}
\alias{e_graph_edges}
\title{Graph}
\usage{
e_graph(e, layout = "force", name = NULL, rm_x = TRUE, rm_y = TRUE, ...)

e_graph_gl(
  e,
  layout = "force",
  name = NULL,
  rm_x = TRUE,
  rm_y = TRUE,
  ...,
  itemStyle = list(opacity = 1)
)

e_graph_nodes(
  e,
  nodes,
  names,
  value,
  size,
  category,
  symbol = NULL,
  legend = TRUE,
  xpos = NULL,
  ypos = NULL
)

e_graph_edges(e, edges, source, target, value, size, color)
}
\arguments{
\item{e}{An \code{echarts4} object as returned by \code{e_charts}.}

\item{layout}{Layout, one of \code{force}, \code{none} or \code{circular}.}

\item{name}{Name of graph.}

\item{rm_x, rm_y}{Whether to remove the x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other parameter.}

\item{itemStyle}{This option is available for for GL and canvas
graph but is only necessary for GL.}

\item{nodes}{Data.frame of nodes.}

\item{names}{Names of nodes, unique.}

\item{value}{Values of nodes or edges.}

\item{size}{Sizes of nodes or edges.}

\item{category}{Group of nodes (i.e.: group membership).}

\item{symbol}{Symbols of nodes.}

\item{legend}{Whether to add serie to legend.}

\item{xpos, ypos}{X and Y coordinates for nodes. Valid when \code{layout = "none"}}

\item{edges}{Data.frame of edges.}

\item{source, target}{Column names of source and target.}

\item{color}{Variable to map to the color of the edges.}
}
\description{
Create a graph.
}
\examples{
value <- rnorm(10, 10, 2)

nodes <- data.frame(
  name = sample(LETTERS, 10),
  value = value,
  size = value,
  symbol = sample(c("circle", "rect", "triangle"), 10, replace = TRUE),
  grp = rep(c("grp1", "grp2"), 5),
  stringsAsFactors = FALSE
)

value_edges <- sample(1:100, 20, replace = TRUE)
edges <- data.frame(
  source = sample(nodes$name, 20, replace = TRUE),
  target = sample(nodes$name, 20, replace = TRUE),
  value = value_edges,
  size = ceiling(value_edges / 20),
  stringsAsFactors = FALSE
)

e_charts() |>
  e_graph() |>
  e_graph_nodes(nodes, name, value, size, grp, symbol) |>
  e_graph_edges(edges, source, target, value, size) |>
  e_tooltip()

# Use graphGL for larger networks
nodes <- data.frame(
  name = paste0(LETTERS, 1:1000),
  value = rnorm(1000, 10, 2),
  size = rnorm(1000, 10, 2),
  grp = rep(c("grp1", "grp2"), 500),
  stringsAsFactors = FALSE
)

edges <- data.frame(
  source = sample(nodes$name, 2000, replace = TRUE),
  target = sample(nodes$name, 2000, replace = TRUE),
  stringsAsFactors = FALSE
)

e_charts() |>
  e_graph_gl() |>
  e_graph_nodes(nodes, name, value, size, grp) |>
  e_graph_edges(edges, source, target)

# Fixed node positions, and edge color by variable
nodes <- data.frame(
  name = c("A", "B", "C", "D", "E"),
  value = c("A", "B", "C", "D", "E"),
  group = c("gr1", "gr1", "gr2", "gr2", "gr3"),
  size = 3:7 * 10,
  x = c(0, 200, 400, 600, 800),
  y = c(100, 100, 200, 200, 0)
)

edges <- data.frame(
  source = c("A", "B", "C", "D", "E"),
  target = c("B", "C", "D", "E", "D"),
  size = rep(3, 5),
  color = c("red", "green", "blue", "yellow", "black")
)

e_charts() |>
  e_graph(layout = "none", autoCurveness = TRUE) |>
  e_graph_nodes(nodes, name, value, size, category = group, xpos = x, ypos = y) |>
  e_graph_edges(edges, source, target, size = size, color = color) |>
  e_tooltip()
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-graph}{Additional arguments},
 \code{\link{e_modularity}}
}
