% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_reframe}
\alias{p_reframe}
\title{Summarise a data set}
\usage{
p_reframe(.data, ..., .messages = "", .headline = "", .tag = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame, to add multiple columns from a single expression.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Returning values with size 0 or >1 was
deprecated as of 1.1.0. Please use \code{\link[dplyr:reframe]{reframe()}} for this instead.
  Named arguments passed on to \code{\link[dplyr:reframe]{dplyr::reframe}}\describe{
    \item{\code{.by}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}
}}

\item{.messages}{a set of glue specs. The glue code can use any summary
variable defined in the ... parameter, or any global variable, or
\{.strata\}}

\item{.headline}{a headline glue spec. The glue code can use any summary
variable defined in the ... parameter, or any global variable, or
\{.strata\}}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the .data dataframe summarised with the history graph updated showing
the summarise operation as a new stage
}
\description{
Summarising a data set acts in the normal \code{dplyr} manner to collapse groups
to individual rows. Any columns resulting from the summary can be added to
the history graph. In the history this also joins any stratified branches and
allows you to generate some summary statistics about the un-grouped data. See
\code{\link[dplyr:summarise]{dplyr::summarise()}}.
}
\examples{
library(dplyr)
library(dtrackr)

tmp = iris \%>\% dplyr::group_by(Species) \%>\% track()
tmp \%>\% dplyr::reframe(dplyr::tibble(
  param = c("mean","min","max"),
  value = c(mean(Petal.Length), min(Petal.Length), max(Petal.Length))
  ), .messages="length {param}: {value}") \%>\% history()
}
\seealso{
\code{\link[dplyr:reframe]{dplyr::reframe()}}
}
