% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{suggest_item}
\alias{suggest_item}
\title{Suggest the the closest elements from a string vector}
\usage{
suggest_item(
  x,
  items,
  msg.write = FALSE,
  msg.newline = TRUE,
  msg.item = "variable"
)
}
\arguments{
\item{x}{Character scalar, must be provided. This reference will be compared
to the elements of the string vector in the argument \code{items}.}

\item{items}{Character vector, must be provided. Elements to which the value in
argument \code{x} will be compared.}

\item{msg.write}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, a message is returned,
equal to \code{"Maybe you meant {enum.bq.or ? matches}?"} (see \href{https://lrberge.github.io/stringmagic/articles/guide_string_magic.html}{stringmagic}
for information on the interpolation) if there were matches. If no matches were found,
the message is \code{"FYI the {msg.item}{$s, are, enum.bq ? items}."}.}

\item{msg.newline}{Logical scalar, default is \code{TRUE}. Only used if \code{msg.write = TRUE}.
Whether to add a new line just before the message.}

\item{msg.item}{Character scalar, default is \code{"variable"}. Only used if \code{msg.write = TRUE}.
What does the \code{items} represent?}
}
\value{
It returns a vector of matches. If no matches were found
}
\description{
Compares a character scalar to the elements from a character vector and
returns the elements that are the closest to the input.
}
\details{
This function is useful when used internally to guide the user to relevant choices.

The choices to which the user is guided are in decreasing quality. First light mispells
are checked. Then more important mispells. Finally very important mispells. Completely
off potential matches are not reported.

If the argument \code{msg.write} is \code{TRUE}, then a character scalar is returned containing
a message suggesting the matches.
}
\examples{

# function reporting the sum of a variable
sum_var = function(data, var){
  # var: a variable name, should be part of data
  if(!var \%in\% names(data)){
    suggestion = suggest_item(var, names(data), msg.write = TRUE)
    stopi("The variable `{var}` is not in the data set. {suggestion}")
  }

  sum(data[[var]])
}

# The error message guides us to a suggestion
try(sum_var(iris, "Petal.Le"))

}
\author{
Laurent Berge
}
