% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{setDreamerr_show_stack}
\alias{setDreamerr_show_stack}
\title{Settings telling whether or not to display the full call stack on errors}
\usage{
setDreamerr_show_stack(show_full_stack = FALSE)
}
\arguments{
\item{show_full_stack}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, then
errors generated by dreamerr functions (like \code{\link[=stop_up]{stop_up()}}/\code{\link[=stopi]{stopi()}}) will display
the full call stack.}
}
\description{
Errors generated with dreamerr functions only shows the call to which
the error should point to. If \code{setDreamerr_show_stack} is set to TRUE,
error will display the full call stack instead.
}
\examples{

# Let's create a toy example of a function relying on an internal function
# for the heavy lifting (although here it's pretty light!)
make_sum = function(a, b){
  make_sum_internal(a, b)
}

make_sum_internal = function(a, b){
  if(!is.numeric(a)) stop_up("arg. 'a' must be numeric!")
  a + b
}

# By default if you feed stg non numeric, the call shown is 
# make_sum, and not make_sum_internal, since the user could not
# care less of the internal structure of your functions

try(make_sum("five", 55))

# Now with setDreamerr_show_stack(TRUE), you would get the full call stack
setDreamerr_show_stack(TRUE)
try(make_sum("five", 55))



}
\author{
Laurent Berge
}
