% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2crop.R
\name{bin2crop}
\alias{bin2crop}
\title{Crop a continuous raster by a binary (0/1) raster footprint (value == 1)}
\usage{
bin2crop(
  r_bin,
  r_cont,
  clip = NULL,
  resample_method = "bilinear",
  dissolve = TRUE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{r_bin}{SpatRaster. Binary raster (0/1). Cells with value 1 define the footprint.}

\item{r_cont}{SpatRaster. Continuous raster to crop/mask.}

\item{clip}{Optional SpatVector. Additional polygon to crop/mask the result.}

\item{resample_method}{Character. Method for resampling r_cont to r_bin grid if needed.}

\item{dissolve}{Logical. Dissolve contiguous 1-cells when polygonizing.}

\item{filename}{Optional character. If provided, writes result to disk.}

\item{overwrite}{Logical. Passed to writeRaster if filename is provided.}
}
\value{
SpatRaster (cropped/masked continuous raster).
}
\description{
Crop a continuous raster by a binary (0/1) raster footprint (value == 1)
}
\examples{
\donttest{
library(terra)

# Create continuous raster (e.g., suitability values 0-1)
r_continuous <- rast(ncol = 50, nrow = 50, xmin = 0, xmax = 10,
                     ymin = 0, ymax = 10)
values(r_continuous) <- runif(ncell(r_continuous), 0, 1)
names(r_continuous) <- "suitability"

# Create binary raster (circular study area)
r_binary <- rast(r_continuous)
xy <- xyFromCell(r_binary, 1:ncell(r_binary))
center_dist <- sqrt((xy[,1] - 5)^2 + (xy[,2] - 5)^2)
values(r_binary) <- ifelse(center_dist <= 3, 1, 0)
names(r_binary) <- "study_area"

# Crop continuous raster to binary footprint
result <- bin2crop(r_bin = r_binary, r_cont = r_continuous)

# Plot comparison
par(mfrow = c(1, 3))
plot(r_binary, main = "Binary Footprint (Study Area)")
plot(r_continuous, main = "Original Continuous")
plot(result, main = "Cropped Result")
}

}
