covprod <- function(cov, mat){
  mat <- as.matrix(mat)
  if(is.list(cov)){
    stopifnot(identical(sum(sapply(cov, NROW)), NROW(mat)))
    idx <- rep(seq_along(cov), times = sapply(cov, nrow))
    block_prods <- lapply(seq_along(cov),
                          function(i) cov[[i]] %*% as.matrix(mat)[which(idx == i), ])
    output <- do.call(rbind, block_prods)
  } else {
    if(is.matrix(cov)) {
      output <- cov %*% mat
    } else {
      if(is.vector(cov)) {
        output <- cov * mat
      } else {
        stop("invalid covariance type")
      }
    }
  }
  return(output)
}
