confint.distfreereg <-
  function(object, parm, level = 0.95, ...)
  {
    stopifnot(is(object, "distfreereg"))
    validate_numeric(x = level, max_val_strict = 1, min_val_strict = 0)
    test_mean <- object[["test_mean"]]
    if(isModel(test_mean) || is(test_mean, "formula")){
      if(is(test_mean, "formula")){
        ci_object <- object[["model"]]
        stopifnot(!is.null(ci_object))
      } else {
        ci_object <- object[["test_mean"]]
      }
      confint(object = ci_object, parm = parm, level = level, ...)
    } else {
      confint.default(object = object, parm = parm, level = level, ...)
    }
  }
