% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-download-stream.R
\name{stream_download}
\alias{stream_download}
\title{Stream Download Files to Browser}
\usage{
stream_download(
  filepath,
  filename = basename(filepath),
  session = shiny::getDefaultReactiveDomain(),
  chunk_size = 2 * 1024^2,
  cleanup = FALSE,
  method = c("streamsaver", "blob"),
  quiet = FALSE
)
}
\arguments{
\item{filepath}{path to the file to download; must be an existing file}

\item{filename}{the file name to use for the download (defaults to the base name
of \code{filepath})}

\item{session}{the Shiny session; defaults to \code{shiny::getDefaultReactiveDomain()}}

\item{chunk_size}{size in bytes for each chunk; default is 2 MB}

\item{cleanup}{whether to delete the source file after download completes;
default is \code{FALSE}}

\item{method}{download method: \code{"streamsaver"} (default, uses service worker
for true streaming) or \code{"blob"} (fallback that accumulates chunks in memory)}

\item{quiet}{whether to suppress progress messages; default is \code{FALSE}}
}
\value{
Invisible \code{NULL}; the function is called for its side effects
}
\description{
Push files to browser downloads using \code{'StreamSaver.js'} for efficient
streaming of large files. This function sends file data in chunks to the browser,
which then writes them directly to disk without buffering the entire file in memory.
}
\details{
This function requires the \code{use_shiny_dipsaus()} to be called in your
Shiny UI to load the necessary 'JavaScript' dependencies.

The \code{"streamsaver"} method (default) uses service workers to enable true
streaming downloads that start immediately without buffering the entire file.
This is ideal for large files (100MB+). The \code{"blob"} method is a fallback
that accumulates chunks in memory before triggering the download, which works
on more browsers but uses more memory.
}
\section{Service Worker Requirements}{

\code{'StreamSaver.js'} requires the following files to be served from the same origin:
\itemize{
  \item \code{streamsaver/StreamSaver.js} - Main library
  \item \code{streamsaver/sw.js} - Service worker
  \item \code{streamsaver/mitm.html} - Man-in-the-middle page
}

These files are automatically included when using \code{\link{use_shiny_dipsaus}}.
}

\examples{
if(interactive()) {
  library(shiny)

  ui <- fluidPage(
    use_shiny_dipsaus(),
    actionButton("download_btn", "Download Large File")
  )

  server <- function(input, output, session) {
    observeEvent(input$download_btn, {
      # Create a temporary file to demonstrate
      temp_file <- tempfile(fileext = ".txt")
      writeLines(rep("Hello World!\n", 100000), temp_file)

      # Stream the file to the browser
      stream_download(
        filepath = temp_file,
        filename = "large_file.txt",
        cleanup = TRUE  # Delete temp file after download
      )
    })
  }

  shinyApp(ui, server)
}

}
\seealso{
\code{\link{use_shiny_dipsaus}}, \code{\link{progress2}}
}
