% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readIncludedSites.r
\name{readIncludedSites}
\alias{readIncludedSites}
\title{Read genomic sites from a BED-like file}
\usage{
readIncludedSites(includedSites, ChosenSites = "all")
}
\arguments{
\item{includedSites}{Path to a BED-like file, ideally output from \code{vcf2diem}.}

\item{ChosenSites}{Logical or numeric vector specifying sites to retain, or \code{"all"} to keep all sites.}
}
\value{
A data frame containing the selected sites with 1-based coordinates.
}
\description{
Imports a BED-like file and optionally subsets sites.
}
\examples{
\dontrun{
# Run this example in a working directory with write permissions
myo <- system.file("extdata", "myotis.vcf", package = "diemr")
vcf2diem(myo, "myo")
readIncludedSites("myo-001.txt")
readIncludedSites("myo-001.txt", ChosenSites = 2:7)
}
}
