% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-hfilter.R
\name{autoplot,hfilter-method}
\alias{autoplot,hfilter-method}
\title{\code{ggplot2} Plot Method for the Results of a Hamilton Filter}
\usage{
\S4method{autoplot}{hfilter}(object, which = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"hfilter"}, as returned by the function 
\code{\link{hamilton_filter}}.}

\item{which}{either a string or a number can be entered to select a 
plot type from the function call; options are (1) a facet plot of the 
components, (2) the observed time series, (3) the observations together 
with the fitted values, and (4) the residuals; for \code{which = NULL}, 
the plot type can be selected interactively in the console.}

\item{...}{currently without use, implemented for compatibility.}
}
\value{
This method returns a \code{ggplot2} plot object, i.e. an object of classes 
\code{"gg"} and \code{"ggplot"}.
}
\description{
Visualize the results of an applied Hamilton filter in the style of 
\code{ggplot2}.
}
\examples{
est <- hamilton_filter(log(EXPENDITURES))
autoplot(est, which = 3, col = c(1, 6))
autoplot(est, which = 4)

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
