% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiked_wishart.R
\name{sample_spiked_wishart}
\alias{sample_spiked_wishart}
\title{Efficiently sample the singular values corresponding to a random Wishart matrix with spiked eigenvalues
Specifically, if W = G G^T with each column of G drawn iid from N(0, Sigma), then W is a Wishart matrix and
this function samples the singular values of G. The eigenvalues of W are just the squares of the singular values.
Here, Sigma is diagonal with its leading entries from spiked_sd^2 and all remaining entries are population_sd^2.}
\usage{
sample_spiked_wishart(
  spiked_sd,
  num_observations,
  num_variables,
  population_sd = 1,
  num_eigs = 0
)
}
\arguments{
\item{spiked_sd}{The spiked standard deviations}

\item{num_observations}{The number of observations (aka samples or columns)}

\item{num_variables}{The number of variables (aka features or rows)}

\item{population_sd}{the standard deviation of all non-spiked components (num_variables - length(spiked_sd) of them)}

\item{num_eigs}{The number of eigenvalues to compute. If 0 compute all of them using dense matrix routines. If greater than zero, use sparse matrices and compute that many top eigenvalues.}
}
\value{
Vector of random singular values of G where G is a random num_variables x num_observations matrix with iid columns from N(0, Sigma) where Sigma is diagonal with entries spiked_sd^2 and all the remaining are population_sd^2.
}
\description{
Efficiently sample the singular values corresponding to a random Wishart matrix with spiked eigenvalues
Specifically, if W = G G^T with each column of G drawn iid from N(0, Sigma), then W is a Wishart matrix and
this function samples the singular values of G. The eigenvalues of W are just the squares of the singular values.
Here, Sigma is diagonal with its leading entries from spiked_sd^2 and all remaining entries are population_sd^2.
}
\examples{
set.seed(0)
# Sample eigenvalues of a covariance matrix of a 10 sample study with 1000 variables such that
# the top two (underlying true distribution of the data, not sample) principal components
# have SDs of 100 and 10 and the remaining 98 have 1
sample_spiked_wishart(
  spiked_sd = c(500, 100),
  num_variables = 1000,
  num_observations = 10-1,
  num_eigs = 3
)

}
