% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_dev_version.R
\name{is_dev_version}
\alias{is_dev_version}
\title{Check whether deepSTRAPP is a development version}
\usage{
is_dev_version(pkg = "deepSTRAPP")
}
\arguments{
\item{pkg}{Character string. Name of the R package for which the version type is inspected.
Default is "deepSTRAPP".}
}
\value{
Logical. TRUE if running a development version.
}
\description{
Detect whether the current deepSTRAPP installation corresponds to
a development version (e.g., version sourced from GitHub), as opposed to a CRAN release.

The development versions include deepSTRAPP outputs as additional internal datasets to help
produces examples and vignettes outputs. These additional datasets are removed from the CRAN releases
because their size is not compatible with CRAN policies.

This function is only used to check if an example must be ran or a vignette chunk evaluated
to produce output from data.
}
\examples{
# Check the current deepSTRAPP installation is a development version
is_dev_version(pkg = "deepSTRAPP")

}
\author{
Maël Doré
}
