% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{Ponerinae_biogeo_data_old_calib}
\alias{Ponerinae_biogeo_data_old_calib}
\title{Data summarizing the evolution of geographic ranges in Ponerinae ants using an old ill-calibrated phylogeny for illustrative purposes}
\format{
A list with 6 elements.
}
\usage{
data(Ponerinae_biogeo_data_old_calib)
}
\description{
A list containing geographic ranges data of Ponerinae mapped on the old ill-calibrated phylogeny,
modeled with R package \code{BioGeoBEARS}. Ranges are labeled between "Old World" (O) and New World (N).
This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
The phylogeny used is also NOT a properly time-calibrated phylogeny. It uses an ill-designed old calibration for illustrative purposes.

Source: Doré, M., Borowiec, M. L., Branstetter, M. G., Camacho, G. P., Fisher, B. L., Longino, J. T., Ward, P. S., Blaimer, B. B. (2025).
Evolutionary history of ponerine ants highlights how the timing of dispersal events shapes modern biodiversity. Nature Communications, 16, 8297.
\doi{10.1038/s41467-025-63709-3}
}
\details{
A list of five objects containing information on the evolution of feeding habits in eels.
This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
\itemize{
\item \verb{$densityMaps} List of objects of class \verb{"densityMap} that contains a phylogenetic tree and associated mapping of probability
to harbor a given range along branches. The list contains only a \verb{"densityMap} per unique areas because \code{split_multi_area_ranges} was set to TRUE.
In this case, unique areas are "N" (= "New World") and "O" (= "Old World)
\item \verb{$densityMaps_all_ranges} List of objects of class \verb{"densityMap} that contains a phylogenetic tree and associated mapping of probability
to harbor a given range along branches. The list contains one \verb{"densityMap} per range found along branches during the simulated biogeographic histories.
Here those ranges are "N" (= "New World"), "O" (= "Old World), and "NO" for multi-area ranges encompassing both regions.
\item \verb{$trait_data_type} Character string. Record the type of trait data. Here: "biogeographic".
\item \verb{$ace} Numerical matrix that record the posterior probabilities of ancestral ranges estimated at internal nodes.
Only unique areas (i.e., "N" and "O") are considered among the ranges. Multi-area ranges (i.e., "NO") have been split among unique ranges.
Rows are internal nodes. Columns are ranges. Values are posterior probabilities of each range per node.
\item \verb{$ace_all_ranges} Numerical matrix that record the posterior probabilities of ancestral ranges estimated at internal nodes.
All ranges observed along branches during the simulated biogeographic histories are present (i.e., "N", "O", and "NO").
Rows are internal nodes. Columns are ranges. Values are posterior probabilities of each range per node.
\item \verb{$model_selection_df} Data.frame that summarizes model comparisons used to select the best fitting model.
}
}
\references{
Doré, M., Borowiec, M. L., Branstetter, M. G., Camacho, G. P., Fisher, B. L., Longino, J. T., Ward, P. S., Blaimer, B. B. (2025).
Evolutionary history of ponerine ants highlights how the timing of dispersal events shapes modern biodiversity. Nature Communications, 16, 8297.
\doi{10.1038/s41467-025-63709-3}
}
\seealso{
\code{\link[=prepare_trait_data]{prepare_trait_data()}}
}
\keyword{datasets}
