% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtmr.R
\docType{data}
\name{dtmr_data}
\alias{dtmr_data}
\alias{dtmr}
\alias{dtmr_qmatrix}
\alias{dtmr_true_structural}
\alias{dtmr_true_profiles}
\alias{dtmr_true_items}
\title{Diagnosing teachers' multiplicative reasoning (DTMR)}
\format{
\code{dtmr_data} is a \link[tibble:tibble-package]{tibble} containing
simulated DTMR response data with 990 rows and 28 variables.
\itemize{
\item \code{id}: Respondent identifier.
\item \code{1}-\code{22}: Simulated dichotomous item responses to the 27 DTMR items.
}

\code{dtmr_qmatrix} is a \link[tibble:tibble-package]{tibble} that identifies
which skills are measured by each DTMR item, as reported in Bradshaw et al.
(2014). The DTMR assessment contains 27 items measuring 4 skills.
The \code{dtmr_qmatrix} correspondingly is made up of 27 rows
and 5 variables.
\itemize{
\item \code{item}: Item identifier, corresponds to \code{1}-\code{22} in \code{dtmr_data}.
\item \code{referent_units}, \code{partitioning_iterating}, \code{appropriateness}, and
\code{multiplicative_comparison}: Dichotomous indicator for whether or not the
skill is measured by each item. A value of \code{1} indicates the skill is
measured by the item and a value of \code{0} indicates the skill is not measured
by the item.
}

\subsection{Simulation values}{

In addition to the simulated data sets, the true values used to simulate the
data are included for reference. This may be useful if, for example, you want
to estimate a model and then check how well the estimated parameters match
values that were used to create the data.

To simulate the data, we first need \code{dtmr_true_structural}. This is a
\link[tibble:tibble-package]{tibble} that contains the structural parameters
reported in Figure 10 of Izsák et al. (2019). The structural parameters
define the probability of observing each possible profile in the population
of respondents. Each row represents one possible mastery profile. Therefore,
there are 16 rows and
5 variables.
\itemize{
\item \code{referent_units}, \code{partitioning_iterating}, \code{appropriateness},
\code{multiplicative_comparison}: Integer values indicating whether each
attribute has been mastered by respondents with the given profile.
\item \code{class_probability}: The proportion of respondents estimated to demonstrate
the given pattern of mastery.
}
}

Using the \code{dtmr_true_structural} values, we randomly sampled a mastery
profile for each of the 990 respondents. The true profiles for each
respondent are available in \code{dtmr_true_profiles}. There are a total of
990 rows and 5 variables.
\itemize{
\item \code{id}: Respondent identifier, corresponds to \code{id} in \code{dtmr_data}.
\item \code{referent_units}, \code{partitioning_iterating}, \code{appropriateness},
\code{multiplicative_comparison}: Integer values indicating whether each
attribute has been mastered by the respondent.
}

We use the \code{dtmr_true_profiles} and the \code{dtmr_qmatrix} to identify whether
each respondent possess the attributes required by each item. Based on which
attributes are required and possessed, we use the \code{dtmr_true_items} to
calculate the log odds of each respondent providing a correct response to
each item. \code{dtmr_true_items} contains the estimated item parameters reported
in Table 1 of Bradshaw et al. (2014). This a \link[tibble:tibble-package]{tibble}
with 27 rows and 7 columns.
\itemize{
\item \code{item}: Item identifier, corresponds to \code{1}-\code{22} in \code{dtmr_data}.
\item \code{intercept}: The LCDM intercept parameter for each item.
\item \code{referent_units}: The LCDM main effect parameter for items measuring the
referent units attribute.
\item \code{partitioning_iterating}: The LCDM main effect parameter for items
measuring the partitioning and iterating attribute.
\item \code{appropriateness}: The LCDM main effect parameter for items measuring the
appropriateness attribute.
\item \code{multiplicative_comparison}: The LCDM main effect parameter for items
measuring the multiplicative comparisons attribute.
\item \code{referent_units__partitioning_iterating}: The LCDM interaction parameter
for items measuring both referent units and partitioning and iterating
attributes.
}

Finally, we convert the log odds values to probabilities and draw a random
Bernoulli variable using the probabilities of a correct response. The drawn
Bernoulli values are the simulated item scores that make up the \code{dtmr_data}.
}
\usage{
dtmr_data

dtmr_qmatrix

dtmr_true_structural

dtmr_true_profiles

dtmr_true_items
}
\description{
This is a simulated data set modeled after the DTMR study described by
Bradshaw et al. (2014) and Izsák et al. (2019). The data was simulated from
the loglinear cognitive diagnostic model (LCDM), which is the model that was
used to analyze the data in the referenced articles. The data set consists of
990 responses to the 27 items included in the final version of the DTMR data,
matching the sample that was collected by the original authors. Each
respondent was randomly assigned a mastery profile using the profile
proportions reported in Figure 10 of Izsák et al. (2019). Item responses were
then generated for each respondent using their assigned mastery profile and
the item parameters reported in Table 1 of Bradshaw et al. (2014).
Reproducible code for generating the simulated data is available in the
\href{https://github.com/r-dcm/dcmdata}{GitHub repository} for this package.
}
\details{
The skills correspond to knowledge of:
\enumerate{
\item Referent units
\item Partitioning and iterating
\item Appropriateness
\item Multiplicative comparisons
}
}
\references{
Bradshaw, L., Izsák, A., Templin, J., & Jacobson, E. (2014).
Diagnosing teachers' understandings of rational numbers: Building a
multidimensional test within the diagnostic classification framework.
\emph{Educational Measurement: Issues and Practice, 33}(1), 2-14.
\doi{10.1111/emip.12020}

Izsák, A., Jacobson, E., & Bradshaw, L. (2019). Surveying
middle-grades teachers' reasoning about fraction arithmetic in terms of
measured quantities. \emph{Journal for Research in Mathematics Education,
50}(2), 156-209. \doi{10.5951/jresematheduc.50.2.0156}
}
\keyword{datasets}
