% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_RelMS.R
\name{robust_RelMS}
\alias{robust_RelMS}
\title{Robust RelMS Distance}
\usage{
robust_RelMS(data, w, p, robust_cov)
}
\arguments{
\item{data}{Numeric matrix or data frame with all variables combined.}

\item{w}{Numeric vector of weights for each observation. Will be normalized internally.}

\item{p}{Integer vector of length 3: \code{c(#cont, #binary, #categorical)}.}

\item{robust_cov}{Robust covariance matrix for continuous variables.}
}
\value{
A numeric matrix of squared robust distances normalized by geometric variability.
}
\description{
Computes a robust version of the Gower distance using the RelMS method
for mixed-type data (continuous, binary, categorical).
Continuous variables are handled via a robust Mahalanobis distance using a supplied robust covariance matrix.
Binary and categorical variables are transformed into distances via similarity coefficients and
combined using the RelMS approach.
}
\details{
The function computes distances separately for continuous, binary, and categorical variables,
then applies the RelMS combination procedure. Continuous distances are Mahalanobis distances,
categorical distances use a matching coefficient, and binary distances use a modified similarity coefficient.
Eigen decomposition is used to compute the square root matrices needed in the RelMS combination.
}
\keyword{internal}
