% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\name{uploadDataPackage}
\alias{uploadDataPackage}
\alias{uploadDataPackage,D1Client-method}
\title{Upload a DataPackage to a DataONE member node.}
\usage{
uploadDataPackage(x, ...)

\S4method{uploadDataPackage}{D1Client}(
  x,
  dp,
  replicate = NA,
  numberReplicas = NA,
  preferredNodes = NA,
  public = as.logical(FALSE),
  accessRules = NA,
  quiet = as.logical(TRUE),
  resolveURI = as.character(NA),
  packageId = as.character(NA),
  as = "character",
  ...
)
}
\arguments{
\item{x}{A D1Client instance.}

\item{...}{(Not yet used.)}

\item{dp}{The DataPackage instance to be submitted to DataONE for creation.}

\item{replicate}{A value of type \code{"logical"}, if TRUE then DataONE will replicate this object to other member nodes}

\item{numberReplicas}{A value of type \code{"numeric"}, for number of supported replicas.}

\item{preferredNodes}{A list of \code{"character"}, each of which is the node identifier for a node to which a replica should be sent.}

\item{public}{A \code{'logical'}, if TRUE then all objects in this package will be accessible by any user}

\item{accessRules}{Access rules of \code{'data.frame'} that will be added to the access policy of each object in the datapackage.}

\item{quiet}{A \code{'logical'}. If TRUE (the default) then informational messages will not be printed.}

\item{resolveURI}{A URI to prepend to identifiers (i.e. for use when creating the ResourceMap). See \link[datapack:serializePackage]{serializePackage}}

\item{packageId}{A value of type \code{"character"} specifying a unique identifier to use for the uploaded package (resource map pid)}

\item{as}{A value of type \code{"character"} that specifies the return value. Possible values are \code{"character"} (the default) or \code{"DataPackage"}.}
}
\value{
id The identifier of the resource map for this data package
}
\description{
Upload all DataObjects contained in the DataPackage by calling \code{\link[=uploadDataObject]{uploadDataObject()}}
on each of the members. Also a resourceMap object is created from the
recorded relationships between DataObjects, and this is uploaded as well.
}
\details{
The DataPackage describes the collection of data object and their associated
metadata object, with the relationships and members serialized into a document
stored under, and retrievable with, the packageId as it's own distinct object.
Any objects in the data map that have a dateUploaded value are assumed to be
pre-existing in the system, and skipped.
}
\note{
Member objects are created serially, and most errors in creating one object will
interrupt the create process for the whole, with the result that some members will
be created, and the remainder not.
}
\examples{
\dontrun{
library(dataone)
library(datapack)
dp <- new("DataPackage")
sampleData <- system.file("extdata/sample.csv", package="dataone")
dataObj <- new("DataObject", format="text/csv", file=sampleData)
dataObj <- setPublicAccess(dataObj)
sampleEML <- system.file("extdata/strix-pacific-northwest.xml", package="dataone")
metadataObj <- new("DataObject", format="eml://ecoinformatics.org/eml-2.1.1", file=sampleEML)
metadataObj <- setPublicAccess(metadataObj)
dp <- addMember(dp, do = dataObj, mo = metadataObj)
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
# Upload all members of the DataPackage to DataONE (requires authentication)
packageId <- uploadDataPackage(d1c, dp, replicate=TRUE, public=TRUE, numberReplicas=2)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client()}} class description.
}
