% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{dc_get_classes}
\alias{dc_get_classes}
\title{Get All Available Classes from Data Commons}
\usage{
dc_get_classes(
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{api_key}{Your Data Commons API key. If not provided, will use the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, it must end with "/core/api/v2/".}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list (if \code{return_type = "list"}) or JSON string (if
\code{return_type = "json"}) containing all available entity classes.
}
\description{
A convenience wrapper around \code{\link[=dc_get_node]{dc_get_node()}} to retrieve all available
entity classes in Data Commons. This is equivalent to calling \code{\link[=dc_get_node]{dc_get_node()}}
with \code{nodes = "Class"} and \code{expression = "<-typeOf"}.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all entity classes
all_classes <- dc_get_classes(return_type = "json")
\dontshow{\}) # examplesIf}
}
