% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{teams.int}
\alias{teams.int}
\title{Pickup League Teams Interval Dataset}
\format{
A data frame with 5 observations and 4 variables:
\itemize{
    \item \code{team_type}: Performance category (Very Good, Good, Average, Fair, Poor).
    \item \code{age}: Player age range (years).
    \item \code{weight}: Player weight range (pounds).
    \item \code{speed}: Speed range -- time to run 100 yards (seconds).
}
}
\usage{
data(teams.int)
}
\description{
Interval-valued data for 5 teams in a local pickup league, classified
by season performance. Each team is described by ranges of player age,
weight, and speed.
}
\details{
The symbolic results are more informative than classical midpoint analyses:
the Very Good team has homogeneous players, whereas the Poor team has
players varying widely in age, weight, and speed. Used for symbolic
principal component analysis.
}
\examples{
data(teams.int)
}
\references{
Billard, L. and Diday, E. (2006). \emph{Symbolic Data Analysis}. Wiley.
Table 2.24, p.63.
}
\keyword{PCA}
\keyword{datasets}
\keyword{interval}
