% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_aau}
\alias{est_aau}
\title{Estimate Amino Acid Usage Frequencies of CDSs.}
\usage{
est_aau(cf, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{codon_table}{codon_table a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}
}
\value{
a data.table with amino acid frequencies of CDSs. The columns include three-letter abbreviation of the amino acid, 
single-letter abbreviation, usage frequency of the amino acid in all sequences, and usage frequency proportion.
}
\description{
Estimate Amino Acid Usage Frequencies of CDSs.
}
\examples{
# estimate amino acid frequencies of yeast genes
cf_all <- count_codons(yeast_cds)
aau <- est_aau(cf_all)
print(aau)
}
