% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan.R
\name{scan_dbl}
\alias{scan_dbl}
\alias{scan_int}
\alias{scan_str}
\title{Read values encoded as characters strings}
\usage{
scan_dbl(con, n = 1, quiet = TRUE, ...)

scan_int(con, n = 1, quiet = TRUE, ...)

scan_str(con, n = 1, quiet = TRUE, ...)
}
\arguments{
\item{con}{Connection object or raw vector. Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{n}{Number of elements to read. Default: 1}

\item{quiet}{Default: TRUE}

\item{...}{further arguments passed to \code{scan()}}
}
\value{
Value of the given type
}
\description{
A lightweight wrapper around the standard \code{\link{scan}()} function.
}
\details{
These functions are useful when the numeric values are encoded as strings written 
to the file, rather than as binary data.  Values must be delimited
by whitespace or other specified separator.  See documentation for 
\code{scan()} for more information.
}
\examples{
con <- textConnection(r"(
  type
  20 30
  3.14159
)")

scan_str(con)
scan_int(con)
scan_int(con)
scan_dbl(con)
close(con)
}
\seealso{
Other data input functions: 
\code{\link{read_f64}()},
\code{\link{read_hex}()},
\code{\link{read_raw}()},
\code{\link{read_str}()},
\code{\link{read_uint8}()}
}
\concept{data input functions}
