% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctxr_options.R
\name{ctxR_options}
\alias{ctxR_options}
\alias{set_ctxR_option}
\alias{has_ctxR_options}
\alias{has_ctxR_option}
\title{ctxR Options}
\usage{
set_ctxR_option(...)

has_ctxR_options()

has_ctxR_option(option)
}
\arguments{
\item{...}{a named listing of options to set}

\item{option}{a specific option to query, e.g. \code{display_api_key}}
}
\value{
\itemize{
\item \code{set_ctxR_option()} does not have a return value but has the side effect
of setting options used by other functions.
\item \code{has_ctxR_option()} returns a Boolean.
\item \code{has_ctxR_options()} returns a Boolean.
}
}
\description{
ctxR stores options as a named list in R's global options, i.e.
\code{getOption('ctxR')}. It currently stores two such options, one for CCTE
credentialing and one to suppress private API information in the URLs printed
to the screen when web queries are placed. For both of those, see
\code{\link[=register_ctx_api_key]{register_ctx_api_key()}}.
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Set ctxR options
set_ctxR_option('display_api_key' = FALSE)
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Check if there are options registered to 'ctxR'
has_ctxR_options()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Check if a specific option is registered for 'ctxR'
has_ctxR_option('display_api_key')
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=register_ctx_api_key]{register_ctx_api_key()}}
}
