% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{num_symm_settings}
\alias{num_symm_settings}
\title{Number of space group settings}
\usage{
num_symm_settings(SG = NULL)
}
\arguments{
\item{SG}{A character string or a number indicating the space group.}
}
\value{
nsett The number of setting for the given space group.
}
\description{
Although a space group is uniquely defined, i.e. the symmetry operations defining it
is uniquely given, the choice of vectors that defines a unit cell for that symmetry
is not unique. The different choices are known as settings. Most space groups have only
one setting, but it is possible to find space groups with several settings. For example,
"C 1 2/c 1" has 18 settings. While the xHM symbol for setting 1 is "C 1 2/c 1", the
symbol for setting 2 is "A 1 2/n 1", etc.
}
\examples{
# P 1 21 1 (group number 4) has three settings
num_symm_settings(4)

# Find the extended Hermann-Mauguin symbols
translate_SG(4,"number","xHM",1)$msg
translate_SG(4,"number","xHM",2)$msg
translate_SG(4,"number","xHM",3)$msg

}
