% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_resid_gf_squaresid.R
\name{gf_squaresid}
\alias{gf_squaresid}
\title{Add Squared Residual Visualization to a Plot}
\usage{
gf_squaresid(plot, model, aspect = 4/6, alpha = 0.1, ...)
}
\arguments{
\item{plot}{A ggformula plot object, typically created with \code{gf_point()}.}

\item{model}{A fitted linear model object created using \code{lm()}.}

\item{aspect}{A numeric value controlling the square's aspect ratio. Default is \code{4/6}.}

\item{alpha}{A numeric value specifying the transparency of the square's fill. Default is \code{0.1}.}

\item{...}{Additional aesthetics passed to \code{geom_polygon()}, such as \code{color} and \code{fill}.}
}
\value{
A ggplot object with squared residuals added.
}
\description{
This function adds squared residual representations to a ggformula plot, illustrating
squared error as a polygon. The function dynamically adjusts the aspect ratio to ensure
proper scaling of squares.
}
\examples{
Height_model <- lm(Thumb ~ Height, data = Fingers)
gf_point(Thumb ~ Height, data = Fingers) \%>\%
  gf_model(Height_model) \%>\%
  gf_squaresid(Height_model, color = "blue", alpha = 0.5)
}
