% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_ver_exists.R
\name{r_ver_exists}
\alias{r_ver_exists}
\title{Check if a specific Rocker image tag exists}
\usage{
r_ver_exists(version, r_mode = "base", verbose = FALSE)
}
\arguments{
\item{version}{Character string. The tag to check for existence, e.g. \code{"4.4.0"}, \code{"devel"}, or \code{"4.4.0-cuda12.2-ubuntu22.04"}.
Must match semantic versioning or be one of \code{"latest"}, \code{"devel"}.}

\item{r_mode}{Character string. One of \code{"base"}, \code{"rstudio"}, or \code{"tidyverse"}.
Determines which Rocker image to query.}

\item{verbose}{Logical. If \code{TRUE}, prints messages indicating whether the version was found.}
}
\value{
Logical. \code{TRUE} if the specified version tag exists for the given Rocker image; otherwise \code{FALSE}.
}
\description{
Validates the format of a version string and checks whether it exists among the available tags
for a specified Rocker image on Docker Hub. Supports semantic versioning, CUDA variants, and Ubuntu suffixes.
}
\keyword{internal}
