% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{cong_summaries}
\alias{cong_summaries}
\title{Request Bill Summary Information}
\usage{
cong_summaries(
  congress = NULL,
  type = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{type}{Type of bill. Can be \code{'hr'}, \code{'s'}, \code{'hjres'}, \code{'sjres'}, \code{'hconres'}, \code{'sconres'}, \code{'hres'}, or \code{'sres'}.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
a \code{tibble::tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Bill Summary Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_summaries()

cong_summaries(congress = 117)

cong_summaries(congress = 117, type = 'hr')
\dontshow{\}) # examplesIf}
}
