% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stat_sum_df}
\alias{stat_sum_df}
\title{Generating the sum and adding a crossbar.}
\usage{
stat_sum_df(fun, geom = "crossbar", ...)
}
\arguments{
\item{fun}{function}

\item{geom}{geom to be shown}

\item{...}{Additional arguments passed to stat_summary}
}
\value{
A \code{ggplot2} layer that can be added to a ggplot object.
}
\description{
Generating the sum and adding a crossbar.
}
\examples{
\donttest{
  # Simple summary function: use the mean as y, ymin, and ymax
  mean_fun <- function(x) {
    m <- mean(x, na.rm = TRUE)
    data.frame(y = m, ymin = m, ymax = m)
  }

  ggplot2::ggplot(mtcars, ggplot2::aes(x = factor(cyl), y = mpg)) +
    stat_sum_df(mean_fun)
}
}
