% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ggbetweenstatsWithPriorNormalityCheck}
\alias{ggbetweenstatsWithPriorNormalityCheck}
\title{Check the data's distribution. If non-normal, take the non-parametric variant of \emph{ggbetweenstats}.
x and y have to be in parentheses, e.g., "ConditionID".}
\usage{
ggbetweenstatsWithPriorNormalityCheck(
  data,
  x,
  y,
  ylab,
  xlabels,
  showPairwiseComp = TRUE,
  plotType = "boxviolin"
)
}
\arguments{
\item{data}{the data frame}

\item{x}{the independent variable, most likely "ConditionID"}

\item{y}{the dependent variable under investigation}

\item{ylab}{label to be shown for the dependent variable}

\item{xlabels}{labels to be used for the x-axis}

\item{showPairwiseComp}{whether to show pairwise comparisons, TRUE as default}

\item{plotType}{either "box", "violin", or "boxviolin" (default)}
}
\value{
A \code{ggplot} object produced by \code{ggstatsplot::ggbetweenstats}, which can be printed or further modified with \code{+}.
}
\description{
Check the data's distribution. If non-normal, take the non-parametric variant of \emph{ggbetweenstats}.
x and y have to be in parentheses, e.g., "ConditionID".
}
\examples{
\donttest{

set.seed(123)

# Toy within-subject style data
main_df <- data.frame(
  Participant = factor(rep(1:20, each = 3)),
  CondID      = factor(rep(c("A", "B", "C"), times = 20)),
  tlx_mental  = rnorm(60, mean = 50, sd = 10)
)

# Custom x-axis labels
labels_xlab <- c("Condition A", "Condition B", "Condition C")


ggbetweenstatsWithPriorNormalityCheck(
  data = main_df,
  x = "CondID",
  y = "tlx_mental", ylab = "Mental Demand",
  xlabels = labels_xlab,
  showPairwiseComp = TRUE
)
}
}
