% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{generate_report_chellinger}
\alias{generate_report_chellinger}
\title{Generate a Microsoft Word document about the Hellinger distances matrix or matrices (two or more) and the p-values matrix or matrices (two or more).}
\usage{
generate_report_chellinger(
  dataset,
  formula,
  pvalue.method = "permutation",
  seed = NULL,
  min_group_size = 3
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A variable or variables (two or more) with factors which you want to calculate the Hellinger distances matrix or matrices (two or more) and the p_values matrix or matrices (two or more).}

\item{pvalue.method}{A p_value method used to calculate the matrix or matrices (two or more), the default value is "permutation". Another method is "bootstrap".}

\item{seed}{Optionally, set a seed for 'bootstrap' and 'permutation'.}

\item{min_group_size}{Minimum group size to maintain. The default value is 3,therefore groups, inside variables, with less than 3 observations will be discarded.}
}
\value{
A Microsoft Word document about the Hellinger distances matrix or matrices (two or more) and the p_values matrix or matrices (two or more).
}
\description{
This function takes a dataframe, a factor or factors (two or more) and returns a Microsoft Word document about the Hellinger distances matrix or matrices (two or more) and the p-values matrix or matrices (two or more).
}
\examples{
# Example with iris dataset
data(iris)

# Generate a report about "Species" factor in iris dataset
generate_report_chellinger(iris, ~Species,
pvalue.method = "bootstrap")

# Example with mtcars dataset
data(mtcars)

# Generate a report about "am" factor in mtcars dataset
generate_report_chellinger(mtcars, ~am, 
pvalue.method = "bootstrap", seed = 100)

}
