% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_core.R
\name{run_clustering}
\alias{run_clustering}
\title{Perform clustering analysis}
\usage{
run_clustering(data, method, k = 3, eps = 0.5, minPts = 5)
}
\arguments{
\item{data}{A numeric matrix or data frame, typically standardized, to be clustered.}

\item{method}{A string indicating the clustering method to use. Options are: "KMeans", "Hierarchical", "DBSCAN", "PAM", "GMM", "Spectral".}

\item{k}{An integer specifying the number of clusters. Required for KMeans, Hierarchical, PAM, GMM, and Spectral.}

\item{eps}{A numeric value specifying the epsilon parameter for DBSCAN. Default is 0.5.}

\item{minPts}{An integer specifying the minimum number of points for DBSCAN. Default is 5.}
}
\value{
A list containing two elements:
\describe{
  \item{cluster}{A vector of cluster labels assigned to each observation.}
  \item{silhouette}{An object of class \code{silhouette} representing silhouette widths.}
}
}
\description{
This function performs clustering on a numeric matrix using one of six common clustering methods:
KMeans, Hierarchical, DBSCAN, PAM, Gaussian Mixture Model (GMM), or Spectral Clustering.
}
\examples{
data(iris)
result <- run_clustering(scale(iris[, 1:4]), method = "KMeans", k = 3)
print(result$cluster)
if (interactive()) {
  plot(result$silhouette)
}

}
