% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createImagePrompt_v2.R
\name{createImagePrompt_v2}
\alias{createImagePrompt_v2}
\title{Generate Image Prompts version 2}
\usage{
createImagePrompt_v2(
  Base_prompt = "",
  removed_from_image = "",
  style_guidance = "N/A",
  Model = "gpt-4o-mini",
  len = 1000
)
}
\arguments{
\item{Base_prompt}{A string. The main description of the image you want to generate (e.g., "A serene mountain landscape").}

\item{removed_from_image}{A string. Elements or attributes to avoid or exclude from the image (e.g., "people, buildings, text"). Use empty string if not applicable.}

\item{style_guidance}{A string. Style or quality guidance for the image generation (e.g., "photorealistic", "artistic", "detailed", "minimalist"). Default is "N/A".}

\item{Model}{A string. This is the model used for generating the prompts. Default is "gpt-4o-mini".}

\item{len}{An integer. This is the maximum length of the generated prompts. Must be between 1 and 1000. Default is 1000.}
}
\value{
A vector of strings. Each string in the vector is a generated prompt (typically 3 prompts).
}
\description{
Generates optimal prompts for creating images using the OpenAI API.
Given a base prompt, negative elements, and style guidance, it generates three optimized prompts for image creation.
This is an experimental function.
}
\details{
Generate Image Prompts version 2
}
\examples{
\dontrun{
# Example 1: Landscape without specific exclusions
base_prompt <- "A peaceful mountain lake surrounded by pine trees"
removed_from_image <- ""
style_guidance <- "photorealistic, high detail"

res <- createImagePrompt_v2(Base_prompt = base_prompt,
                           removed_from_image = removed_from_image,
                           style_guidance = style_guidance,
                           len = 200)
print(res)

# Example 2: Portrait with specific exclusions
base_prompt <- "A portrait of a wise elderly person"
removed_from_image <- "hat, glasses, jewelry"
style_guidance <- "oil painting style"

res <- createImagePrompt_v2(Base_prompt = base_prompt,
                           removed_from_image = removed_from_image,
                           style_guidance = style_guidance)
print(res)
}
}
\author{
Satoshi Kume
}
