% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{WBR_Sim}
\alias{WBR_Sim}
\title{Simulation Function of Weighted Balance Ratio Design for Binary and Continuous Response}
\usage{
WBR_Sim(n, mu, beta, gamma, m0 = 40, pts.X, pts.Z, response, weight, v = 2)
}
\arguments{
\item{n}{a positive integer. The sample size of the simulated data.}

\item{mu}{a vector of length 2. The true parameters of treatment.}

\item{beta}{a vector of length 2. The true parameters of predictive covariate and interaction with treatment.}

\item{gamma}{a vector of length k. The true parameters of prognostic covariates.}

\item{m0}{a positive integer. The number of first 2m0 patients will be allocated equally to both treatments.}

\item{pts.X}{a vector of length n. The vector of patients' binary predictive covariates.}

\item{pts.Z}{a matrix of \code{n x k}. The matrix of patients' binary prognostic covariates.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}

\item{weight}{a vector of length \code{2+k}. The weight of balance ratio in overall,margin and stratum levels.}

\item{v}{a positive value that controls the randomness of allocation probability function.}
}
\value{
\item{method}{The name of procedure.}
\item{sampleSize}{The sample size of the trial.}
\item{assignment}{The randomization sequence.}
\item{X1proportion}{Average allocation proportion for treatment A when predictive covariate equals the smaller value.}
\item{X2proportion}{Average allocation proportion for treatment A when predictive covariate equals the larger value.}
\item{proportion}{Average allocation proportion for treatment A.}
\item{failureRate}{Proportion of treatment failures (if \code{response = "Binary"}).}
\item{meanResponse}{Mean response value (if \code{response = "Cont"}).}#'
\item{rejectNull}{Logical. Indicates whether the treatment effect is statistically significant based on a Wald test.}
}
\description{
This function simulates a trial using Weighted Balance Ratio design for binary and continuous responses.
}
\examples{
set.seed(123)

# Simulation settings
n = 400                              # total number of patients
mu = c(0.8, 0.8)                     # treatment effects (muA, muB)
beta = c(0.8, -0.8)                  # predictive effect and interaction
gamma = c(0.8, 0.8)                  # prognostic covariate effects
weight = rep(0.25, 4)               # weights for imbalance components

# Generate patient covariates
pts.X = sample(c(1, -1), n, replace = TRUE)  # predictive covariate
pts.Z = cbind(
  sample(c(1, -1), n, replace = TRUE),        # prognostic Z1
  sample(c(1, -1), n, replace = TRUE)         # prognostic Z2
)

# Run simulation for continuous response
result = WBR_Sim(
  n = n,
  mu = mu,
  beta = beta,
  gamma = gamma,
  pts.X = pts.X,
  pts.Z = pts.Z,
  response = "Cont",
  weight = weight
)
}
\concept{Weighted Balance Ratio Design}
