% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CADBCD_Alloc}
\alias{CADBCD_Alloc}
\title{Allocation Function of Covariate Adjusted Doubly Biased Coin Design for Binary and Continuous Response}
\usage{
CADBCD_Alloc(ptsb.cov, ptsb.t, ptsb.Y, ptnow.cov, v = 2, response, target)
}
\arguments{
\item{ptsb.cov}{a \code{n x k} covariate matrix of previous patients.}

\item{ptsb.t}{a treatment vector of previous patients with length \code{n}.}

\item{ptsb.Y}{a response vector of previous patients with length \code{n}.}

\item{ptnow.cov}{a covariate vector of the incoming patient with length \code{k}.}

\item{v}{a non-negative integer that controls the randomness of CADBCD design. The default value is 2.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}

\item{target}{the type of optimal allocation target. Options are \code{"Neyman"} or \code{"RSIHR"}.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's covariates and the previous patients' covariates and responses for Covariate Adjusted Doubly Biased Coin procedure proposed by Zhang and Hu.
}
\details{
To start, we let \eqn{\boldsymbol{\theta}_0} be an initial estimate of \eqn{\boldsymbol{\theta}}, and assign \eqn{m_0} subjects to each treatment using a restricted randomization.
Assume that \eqn{m} (with \eqn{m \geq 2 m_0}) subjects have been assigned to treatments. Their responses \eqn{\{\boldsymbol{Y}_j, j = 1, \ldots, m\}} and the corresponding covariates \eqn{\{\boldsymbol{\xi}_j, j = 1, \ldots, m\}} are observed.
We let \eqn{\widehat{\boldsymbol{\theta}}_m = (\widehat{\boldsymbol{\theta}}_{m, 1}, \widehat{\boldsymbol{\theta}}_{m, 2})} be an estimate of \eqn{\boldsymbol{\theta} = (\boldsymbol{\theta}_1, \boldsymbol{\theta}_2)}.
For each \eqn{k = 1, 2}, the estimator \eqn{\widehat{\boldsymbol{\theta}}_{m, k} = \widehat{\boldsymbol{\theta}}_{m, k}(Y_{j,k}, \boldsymbol{\xi}_j : X_{j,k} = 1, j = 1, \ldots, m)} is based on the observed sample of size \eqn{N_{m,k}}, that is, \eqn{\{(Y_{j,k}, \boldsymbol{\xi}_j) : X_{j,k} = 1, j = 1, \ldots, m\}}.

Define \eqn{\widehat{\rho}_m = \frac{1}{m} \sum_{i=1}^m \pi_1(\widehat{\boldsymbol{\theta}}_m, \boldsymbol{\xi}_i)} and \eqn{\widehat{\pi}_m = \pi_1(\widehat{\boldsymbol{\theta}}_m, \boldsymbol{\xi}_{m+1})}.
When the \eqn{(m+1)}-th subject is ready for randomization and the corresponding covariate \eqn{\boldsymbol{\xi}_{m+1}} is recorded, we assign the patient to treatment 1 with the probability:

\deqn{
\psi_{m+1,1} = \frac{\widehat{\pi}_m \left( \frac{\widehat{\rho}_m}{N_{m,1}/m} \right)^v}
{\widehat{\pi}_m \left( \frac{\widehat{\rho}_m}{N_{m,1}/m} \right)^v+ (1 - \widehat{\pi}_m) \left( \frac{1 - \widehat{\rho}_m}{1 - N_{m,1}/m} \right)^v}
}

and to treatment 2 with probability \eqn{\psi_{m+1,2} = 1 - \psi_{m+1,1}}, where \eqn{v \geq 0} is a constant controlling the degree of randomness—from the most random when \eqn{v = 0} to the most deterministic when \eqn{v \rightarrow \infty}. See Zhang and Hu(2009) for more details.
}
\examples{
set.seed(123)

n_prev = 40
covariates = cbind(Z1 = rnorm(n_prev), Z2 = rnorm(n_prev))
treatment = sample(c(0, 1), n_prev, replace = TRUE)
response = rbinom(n_prev, size = 1, prob = 0.6)

# Simulate new incoming patient
new_patient_cov = c(Z1 = rnorm(1), Z2 = rnorm(1))

# Run allocation function
result = CADBCD_Alloc(
  ptsb.cov = covariates,
  ptsb.t = treatment,
  ptsb.Y = response,
  ptnow.cov = new_patient_cov,
  response = "Binary",
  target = "Neyman"
)
print(result$prob)
}
\references{
Zhang, L. X., Hu, F., Cheung, S. H., & Chan, W. S. (2007). Asymptotic properties of covariate-adjusted response-adaptive designs.
\emph{Annals of Statistics}, 35(3), 1166–1182.

Zhang, L. X., & Hu, F. F. (2009). A new family of covariate-adjusted response adaptive designs and their properties.
\emph{Applied Mathematics—A Journal of Chinese Universities}, 24(1), 1–13.
}
\concept{CADBCD Design}
