% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shash.R
\name{normTable.shash}
\alias{normTable.shash}
\title{Calculate Norm Tables for Sinh-Arcsinh Distribution}
\usage{
normTable.shash(
  model,
  ages,
  start = NULL,
  end = NULL,
  step = 1,
  CI = 0.9,
  reliability = NULL
)
}
\arguments{
\item{model}{Fitted shash model object of class "cnormShash"}

\item{ages}{Numeric vector of age points for norm table generation}

\item{start}{Minimum raw score value for the norm table}

\item{end}{Maximum raw score value for the norm table}

\item{step}{Step size between consecutive raw scores (default: 1)}

\item{CI}{Confidence coefficient (0-1, default: 0.9) for confidence intervals}

\item{reliability}{Reliability coefficient (0-1) for true score confidence intervals}
}
\value{
List of data frames (one per age) containing:
  \item{x}{Raw scores}
  \item{Px}{Probability density values}
  \item{Pcum}{Cumulative probabilities}
  \item{Percentile}{Percentile ranks (0-100)}
  \item{z}{Standardized z-scores}
  \item{norm}{Norm scores in specified scale}
  \item{lowerCI, upperCI}{Confidence intervals (if reliability provided)}
  \item{lowerCI_PR, upperCI_PR}{CI as percentile ranks (if reliability provided)}
}
\description{
Generates norm tables for specific ages based on a fitted SinH-ArcSinH (shash) regression model.
Computes probabilities, percentiles, z-scores, and norm scores for a specified range of raw scores.
Optionally includes confidence intervals when reliability is provided.
}
\details{
For continuous shash distributions, probability densities are computed and converted to
cumulative probabilities and percentiles. When reliability is specified, confidence
intervals include correction for regression to the mean.
}
\examples{
\dontrun{
# Basic norm table
model <- cnorm.shash(age, score)
tables <- normTable.shash(model, ages = c(7, 8, 9), start = 0, end = 50)

# With confidence intervals and finer granularity
tables_ci <- normTable.shash(model, ages = c(8, 9), start = 10, end = 40,
                             step = 0.5, CI = 0.95, reliability = 0.85)
}

}
