% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_block.R
\name{bs_block}
\alias{bs_block}
\title{Block an account}
\usage{
bs_block(
  subject,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{subject}{Character, length 1. Subject to act on, as a handle or did.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of follow information
}
\description{
Block an account
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/block.json}{graph/block.json (2024-12-03)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2024-12-02)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-03)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_block(subject = 'nytimes.com')
\dontshow{\}) # examplesIf}
}
\concept{record}
