\name{rald}
\alias{rald}
\alias{rald}
\title{The asymmetric Laplace distribution}
\description{
  Density for and random values from a three-parameter asymmetric
  Laplace distribution.
}
\usage{
  rald(n, location=0, scale=1, p=0.5)
}
\arguments{
  \item{n}{		Number of random values to be generated. }
  \item{location}{	Location parameter. }
  \item{scale}{		Scale parameter. }
  \item{p}{		Skewness parameter. }
}
\details{
  This generic function generates a random variable from an asymmetric Laplace distribution (ALD).
  The ALD has the following probability density function:
  \deqn{ALD_p(x ; \mu, \sigma) = \frac{p(1-p)}{\sigma}\exp\Big(-\frac{(x-\mu)[p-I(x\le\mu)]}{\sigma}\Big),}
  where \eqn{0 < p < 1} is the skew parameter, \eqn{\sigma > 0} is the scale parameter, \eqn{-\infty < \mu < \infty}
  is the location parameter, and \eqn{I(\cdot)} is the indication function. The range of \eqn{x} is \eqn{(-\infty, \infty)}.
}

\value{  
  \code{rald} gives out a vector of random numbers generated by
  the asymmetric Laplace distribution.
}
\references{
  
	Koenker, R. and Machado, J. (1999). Goodness of fit and related inference processes for quantile regression. 
	\emph{Journal of the American Statistical Association}, \bold{94}(3), 1296-1309.

	Yu, K. and Zhang, J. (2005). A Three-parameter asymmetric Laplace distribution and its extension.
	\emph{Communications in Statistics - Theory and Methods}, \bold{34}, 1867-1879.

}

\keyword{distribution}

