% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_distribution.R
\name{normal_distribution}
\alias{normal_distribution}
\alias{normal_pdf}
\alias{normal_lpdf}
\alias{normal_cdf}
\alias{normal_lcdf}
\alias{normal_quantile}
\title{Normal Distribution Functions}
\usage{
normal_distribution(mean = 0, sd = 1)

normal_pdf(x, mean = 0, sd = 1)

normal_lpdf(x, mean = 0, sd = 1)

normal_cdf(x, mean = 0, sd = 1)

normal_lcdf(x, mean = 0, sd = 1)

normal_quantile(p, mean = 0, sd = 1)
}
\arguments{
\item{mean}{mean parameter (default is 0)}

\item{sd}{standard deviation parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Normal distribution.
}
\examples{
# Normal distribution with mean = 0, sd = 1
dist <- normal_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
normal_pdf(0)
normal_lpdf(0)
normal_cdf(0)
normal_lcdf(0)
normal_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/normal_dist.html}{Boost Documentation} for more details on the mathematical background.
}
