% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{production}
\alias{production}
\title{Extract the production constraints from a spatial interaction model object}
\usage{
production(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{...}{additional parameters}
}
\value{
a vector of production constraints at the origin locations
}
\description{
Extract the production constraints from a spatial interaction model object
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- log(french_cities$population[1:10])
attractiveness <- log(french_cities$area[1:10])
model <- static_blvim(distances, production, 1.5, 1 / 250, attractiveness)
production(model)
## the names of the production vector are set from the distance matrix
## we remove them for testing equality
all.equal(as.numeric(production(model)), production)
}
\seealso{
\code{\link[=attractiveness]{attractiveness()}}, \code{\link[=destination_flow]{destination_flow()}}
}
